/* CPP, Problema del camino crtico */

/* Escrito en GNU MathProg por Andrew Makhorin <mao@gnu.org> */

/* Nota: los costos reducidos de las variables auxiliares phi[j,k] (ver abajo) slo pueden cero o uno. El camino crtico se identifica por las restricciones cuyo costo reducido es uno. */

set J;
/* conjunto de tareas (actividades) */

set P{j in J}, in J, default {};
/* P[j] es el subconjunto de las tareas que preceden inmediatamente a la tarea j */

param t{j in J}, >= 0;
/* duracin requerida para realizar la tarea j */

param last, symbolic, in J;
/* ltima tarea para la versin corta (nota: este parmetro no estaba incluido en la versin original de Makhorin y no es necesario desactivarlo si se usa la versin larga) */

var x{j in J}, >= 0;
/* fecha de inicio de la tarea j */

s.t. phi{j in J, k in P[j]}: x[j] >= x[k] + t[k];
/* la tarea j slo puede iniciarse luego de que se han completado todas las tareas inmediantamente precedentes */

var z;
/* duracin total del proyecto */

#s.t. fin{j in J}: z >= x[j] + t[j];
/* que es el fecha ms tarda de finalizacin de todas las tareas (nota: si se usa la versin corta es necesario desactivarlas) */

s.t. fin{j in J: j = last}: z >= x[j] + t[j];
/* para la versin corta es necesario identificar la ltima tarea con el parametro last (nota: esta restriccin no estaba incluida en la versin original de Makhorin y slo debe activarse si se han desactivado las restricciones fin) */

minimize obj: z;
/* el objetivo es encontrar un z tan pequeño como sea posible */

data;
/* Los datos son los del problema de la presentacin (comprar una propiedad para el establecimiento de plantaciones) y la solucin ptima es 20 */

param : J :  t :=
        A    1    /* Actividad A */
        B    1    /* Actividad B */
        C    1    /* Actividad C */
        D    1    /* Actividad D */
        E    1    /* Actividad E */
        F    3    /* Actividad F */
        G    3    /* Actividad G */
        H    2    /* Actividad H */
        I    4    /* Actividad I */
        J    1    /* Actividad J */
        K    6    /* Actividad K */
        L    1    /* Actividad L */
        M    1    /* Actividad M */
        N    5    /* Actividad N */
        O    1    /* Actividad O */
        P    6 ;  /* Actividad P */

set P[B] := A;
set P[C] := B;
set P[D] := C;
set P[E] := D;
set P[F] := B;
set P[G] := A;
set P[H] := D F;
set P[I] := E G H;
set P[J] := I;
set P[K] := E G H;
set P[L] := K;
set P[M] := E G H;
set P[N] := M;
set P[O] := N;
set P[P] := O J L;

param last := P;

end;