# EL MODELO DE TRANSPORTE

set origenes;
/* Orgenes */

set destinos;
/* Destinos */

param oferta{origenes} >= 0;
/* oferta de la planta i en bibliotecas (capacidad instalada) */

param demanda{destinos} >= 0;
/* demanda del cliente j en bibliotecas */

param distancia{origenes,destinos};
/* distancia desde el origen i hasta el destino j en km */

param flete;
/* valor del flete en pesos por km por biblioteca */

param costo{i in origenes, j in destinos} := flete * distancia[i,j];
/* costo del transporte desde el origen i hasta el destino j en pesos por biblioteca */

var transportar{origenes,destinos} >= 0;
/* cantidades a transportar desde el origen i hasta el destino j en bibliotecas */

minimize Costo_total: sum{i in origenes, j in destinos} costo[i,j] * transportar[i,j];
/* costo total de transporte en pesos */

s.t. Oferta{i in origenes}: sum{j in destinos} transportar[i,j] = oferta[i];
/* respetar el lmite ofrecido por la planta i */

s.t. Demanda{j in destinos}: sum{i in origenes} transportar[i,j] = demanda[j];
/* satisfacer la demanda del cliente j */

data;

set origenes := CBA JUN SFE;
/* Crdoba Junin Santa F */

set destinos := ROS	RCT	VMR	SFR	VTR	RUF	MJU	LCR;
/* Rosario Ro Cuarto Villa Mara San Francisco Venado Tuerto Rufino Marcos Jurez La Carlota */

param oferta :=	CBA	850
								JUN	350
								SFE	500;

param demanda :=	ROS	350
									RCT	240
									VMR	250
									SFR	210
									VTR	190
									RUF	130
									MJU	180
									LCR	150;

param distancia :	ROS	RCT	VMR	SFR	VTR	RUF	MJU	LCR	:=
							CBA	405	213	151	211	409	436	264	275
							JUN	206	393	398	458	155	170	331	285
							SFE	174	434	303	142	325	429	269	427	;

param flete := 1.53;

end;
