/*
UN PROBLEMA DE TRANSPORTE

Con este modelo se resuelve el problema general de optimizar la distribucin de bienes y servicios desde mltiples fuentes hacia mltiples destinos. En particular, el problema minimiza el costo de transportar varios millones de plantines que se producen en tres viveros, hasta cuatro rodales en los que son requeridos para establecer plantaciones.

Bibliografa:

Dykstra DP. 1984. Mathematical programming for natural resource management. McGraw-Hill Book Company, New York. Captulo 7: 190-229 (Ejemplo 7.1).
*/

set I;
/* viveros */

set J;
/* rodales */

param a{i in I};
/* produccin del vivero i, en millones de plantines */

param b{j in J};
/* requerimiento en el rodal j, en millones de plantines*/

param d{i in I, j in J};
/* distancia desde el vivero i hasta el rodal j, en km */

param f;
/* valor del flete, en $ por km y por milln de plantines */

param c{i in I, j in J} := f * d[i,j] / 1000;
/* costo de transporte, en miles de pesos por milln de plantines */

var x{i in I, j in J} >= 0;
/* cantidad de plantines del vivero i transportadas al rodal j, en millones de plantines */

minimize costo: sum{i in I, j in J} c[i,j] * x[i,j];
/* minimizar el costo total de transporte en miles de pesos */

subject to produccion{i in I}: sum{j in J} x[i,j] = a[i];
/* todos los plantines de cada vivero i deben ser transportados */

subject to requerimiento{j in J}: sum{i in I} x[i,j] = b[j];
/* todos los plantines requeridos en el rodal j deben ser transportados */

data;

set I:= vivero_1 vivero_2 vivero_3;
set J:= rodal_1 rodal_2 rodal_3 rodal_4;

param a := vivero_1	5
	   vivero_2	1
	   vivero_3	2;

param b := rodal_1	2
	   rodal_2	3
	   rodal_3	2
	   rodal_4	1;

param d :		rodal_1	rodal_2	rodal_3	rodal_4 :=
	vivero_1	8	19	22	6
	vivero_2	15	6	16	5
	vivero_3	7	8	9	12	;

param f := 1;

end;
