set mat_primas;
set req_nutritivos;

param mezcla_base >= 0; #este nombre no es feliz
param contenido{mat_primas,req_nutritivos} >= 0;
param costo{mat_primas} >= 0;
param min_mat_prima{mat_primas} >= 0;
param max_mat_prima{i in mat_primas} >= min_mat_prima[i];
param min_req_nut{req_nutritivos} >= 0;
param max_req_nut{j in req_nutritivos} >= min_req_nut[j];

var peso{i in mat_primas} >= min_mat_prima[i], <= max_mat_prima[i];

minimize Costo_total: sum {i in mat_primas} costo[i] * peso[i];

subject to Bolsa: sum {i in mat_primas} peso[i] = mezcla_base;
subject to Req_nutritivo{j in req_nutritivos}: min_req_nut[j] <= sum {i in mat_primas} contenido[i,j]*peso[i] <= max_req_nut[j];

data;

set mat_primas := grn_maiz, grn_trigo, svd_trigo, afr_arroz, con_comercial, har_huesos, car_calcio, sal;
set req_nutritivos := prot_cruda, fib_bruta, lisina, calcio, fosforo, sal;

param mezcla_base := 1;

param contenido:	prot_cruda	fib_bruta	lisina	calcio	fosforo	sal		:=
grn_maiz					78.0				16.0			2.3			0.7			0.3			0
grn_trigo			  	114.0				22.0			3.4			0.6			0.34			0
svd_trigo			  	142.0				95.0			6.0			0.3			10.0		0
afr_arroz			  	117.0				72.0			6.5			1.0			13.0		0
con_comercial			800.0				0					546.0		0				1.1			0
har_huesos		  	0						0					0				300.0		140.0		0
car_calcio		 		0						0					0				400.0		0				0
sal						  	0						0					0				0				0				1000;

param: 				costo min_mat_prima max_mat_prima	:=
grn_maiz			  6.8				0					1
grn_trigo			  7.2				0					1
svd_trigo			  2.3				0					1
afr_arroz			  2.2				0					1
con_comercial	230.0				0					1
har_huesos		  5.6				0					1
car_calcio		 11.2				0					1
sal						  4.2				0					1					;

param: 			min_req_nut max_req_nut	:=
prot_cruda			135					145
fib_bruta				 30					 50
lisina					5.6					999
calcio			  	 23					40
fosforo					4.6					6.5
sal		  				3.7					6.0			;

end;
