set productos;
	# diferentes modelos de biblioteca
set procesos;
	# diferentes procesos de producción 

param efi_linea {productos,procesos} > 0;
	# eficiencia de la línea de procesamiento [bibliotecas/hora]
param tmp_disponible {procesos} >= 0;
	# tiempo disponible en cada proceso de producción [horas]
param con_beneficio {productos};
	# contribución al beneficio y los costos fijos [$/biblioteca]
param prd_minima {productos} >= 0;
	# producción mínima de cada modelo [bibliotecas]
param prd_maxima {productos} >= 0;
	# producción máxima de cada modelo [bibliotecas]

var prd_biblioteca {p in productos} >= prd_minima[p], <= prd_maxima[p];
	# producción de cada modelo de bibliotecas [bibliotecas] 

maximize Beneficio: sum {p in productos} con_beneficio[p] * prd_biblioteca[p];
	# Objetivo: maximizar la contribución al beneficio y los costos fijos de la producción de todos los modelos de biblioteca [$]

subject to Tiempo {q in procesos}: sum {p in productos} (1/efi_linea[p,q]) * prd_biblioteca[p] <= tmp_disponible[q];
	# Restricción: la producción de todos los modelos de biblioteca no puede exceder el tiempo disponible en cada línea de procesamiento [horas]

end;
