	set productos;											
# diferentes modelos de biblioteca
	param efi_linea {productos} > 0;
# eficiencia de la linea de procesamiento 
# [bibliotecas/hora]
	param tmp_disponible >= 0;					
# tiempo disponible en la linea de procesamiento [horas]
	param con_beneficio {productos};		
# contribucion al beneficio y los costos fijos 
# [$/biblioteca]
	param prd_minima {productos} >= 0;	
# produccion minima de cada modelo [bibliotecas]
	param prd_maxima {productos} >= 0;	
# produccion maxima de cada modelo [bibliotecas]
	var prd_biblioteca {p in productos} >= prd_minima[p], <= prd_maxima[p];
# produccion de cada modelo de bibliotecas [bibliotecas] 
maximize Beneficio: sum {p in productos} con_beneficio[p] * prd_biblioteca[p];
		# Objetivo: maximizar la contribucion al beneficio y los costos fijos de la produccion de todos los modelos de biblioteca [$]
subject to Tiempo: sum {p in productos} (1/efi_linea[p]) * prd_biblioteca[p] <= tmp_disponible;
		# Restriccion: la produccion de todos los modelos de biblioteca no puede exceder el tiempo disponible en la linea de procesamiento [horas]
end;
