set productos;											# diferentes modelos de biblioteca

param efi_linea {productos} > 0;		# eficiencia de la línea de procesamiento [bibliotecas/hora]
param tmp_disponible >= 0;					# tiempo disponible en la línea de procesamiento [horas]
param con_beneficio {productos};		# contribución al beneficio y los costos fijos [$/biblioteca]
param prd_maxima {productos} >= 0;	# producción máxima de cada modelo [bibliotecas]

var prd_biblioteca {p in productos} >= 0, <= prd_maxima[p];	# producción de cada modelo de bibliotecas [bibliotecas] 

maximize Beneficio: sum {p in productos} con_beneficio[p] * prd_biblioteca[p];
		# Objetivo: maximizar la contribución al beneficio y los costos fijos de la producción de todos los modelos de biblioteca [$]
subject to Tiempo: sum {p in productos} (1/efi_linea[p]) * prd_biblioteca[p] <= tmp_disponible;
		# Restricción: la producción de todos los modelos de biblioteca no puede exceder el tiempo disponible en la línea de procesamiento [horas]
end;
